clear

set more off

use "lpd.dta"

keep if mdate>=tm(1982m1)

keep if age>=16 & !missing(age)


gen year=1982

forvalues i= 1983/2013 { 
	replace year = `i' if mdate>=tm(`i'm1) & mdate<=tm(`i'm12)
}


gen short_term_26 = (udur<=26 & udur>=0 & !missing(udur))
gen long_term_26 = (udur>26 & !missing(udur))




gen employed = 1 if lfs==1 

label define state 11 "Maine" 12 "New Hampshire" 13 "Vermont" 14 "Massachusetts" 15 "Rhode Island" 16 "Connecticut" 21 "New York" 22 "New Jersey" 23 "Pennsylvania" 31 "Ohio" 32 "Indiana" 33 "Illinois" 34 "Michigan" 35 "Wisconsin" 41 "Minnesota" 42 "Iowa" 43 "Missouri" 44 "North Dakota" 45 "South Dakota" 46 "Nebraska" 47 "Kansas" 51 "Delaware" 52 "Maryland" 53 "D.C." 54 "virginia" 55 "West Virginia" 56 "North Carolina" 57 "South Carolina" 58 "Georgia" 59 "Florida" 61 "Kentucky" 62 "Tennessee" 63 "Alabama" 64 "Mississippi" 71 "Arkansas" 72 "Louisiana" 73 "Oklahoma" 74 "Texas" 81 "Montana" 82 "Idaho" 83 "Wyoming" 84 "Colorado" 85 "New Mexico" 86 "Arizona" 87 "Utah" 88 "Nevada" 91 "Washington" 92 "Oregon" 93 "california" 94 "Alaska" 95 "Hawaii" 
label values state state



***Below states from part 1*****
gen below_avg = 1 if state== 94| state== 42 | state== 72 | state== 81 | state== 44 | state== 73 | state== 74 | state==87 | state== 13 | state== 55 | state== 83 
replace below_avg = 2 if missing(below_avg)









collapse (mean) short_term* long_term* [aweight =sswgt], by(year below_avg) 


gen lt_share = long_term/(long_term + short_term)

twoway (scatter lt_share year if below_avg ==1) (scatter lt_share year if below_avg ==2)

***graph is formatted in excel
